<?php
/**
 * Plugin Name: LeadsRx
 * Plugin URI: https://leadsrx.com
 * Description: This plugin adds the LeadsRx tracking code to your website. You'll be able to analyze the effectiveness of your marketing campaigns to improve Return on Advertising Spend using marketing attribution.
 * Version: 1.5.0
 * Author: LeadsRx
 * Author URI: https://leadsRx.com
 * License: GPLv2 or later
 */

add_action('wp_head', 'leadsrx_tracking');
add_action('admin_init', 'leadsrx_settings');
add_action('admin_menu', 'leadsrx_menu');

function leadsrx_tracking() {?>

	<script type="text/javascript">
		var _lab = _lab || [];
		_lab.push('<?php echo (get_option('account_tag') == "" ? "wprc1" : esc_attr(get_option('account_tag'))); ?>');
		(function() {
		   var lab = document.createElement('script');
		   lab.type = 'text/javascript';
		   lab.async = true;
		   lab.src = ('https:' === document.location.protocol ? 'https://app' : 'http://app') + '.leadsrx.com/visitor.js';
		   var s = document.getElementsByTagName('script')[0];
		   s.parentNode.insertBefore(lab, s);
		})();
	</script>

	<?php
}

function leadsrx_settings() {
	register_setting('leadsrx-settings-group', 'account_tag');
}

function leadsrx_menu() {
	add_submenu_page('options-general.php', 'LeadsRx Settings', 'LeadsRx', 'administrator', 'leadsrx-settings', 'leadsrx_settings_page');
}

function leadsrx_settings_page() {?>
	<div class="wrap">
		<h2>LeadsRx Setup</h2>
		<p>
			If you have a paid subscription to LeadsRx, enter your unique Account Tag below (you can find this from your LeadsRx dashboad 
			by selecting Account from the top right menu, then select the Universal Pixel tab).
		</p>
		<p>
			If you do not have a paid subscription to LeadsRx, please contact us <a target="_blank" href="https://leadsrx.com/contact">using this form here. </a>
		</p>
		<form method="post" action="options.php">
			<?php settings_fields('leadsrx-settings-group'); ?>
			<?php do_settings_sections('leadsrx-settings-group'); ?>
			<table class="form-table">
				<tr valign="top">
					<th scope="row">Your LeadsRx Account Tag</th>
					<td><input type="text" name="account_tag" value="<?php echo esc_attr(get_option('account_tag')); ?>" /></td>
				</tr>
			</table>

			<?php submit_button(); ?>

		</form>
	</div>
	<?php
}
